fetchData('./get_all');

const padsStateHandler = new Proxy({
        "closed_hihat": false,
        "kick": false,
        "snare_1": false,
        "crash": false,
        "snare_2": false,
        "open_hihat": false,
        "ride": false
    },
    {
        set: (target, key, value) => {  
            // Reset state to default
            Object.keys(target).forEach(name => {
                target[name] = false;
            });

            // Set current state
            target[key] = value;

            // Select current Pad
            Object.entries(target).forEach(([pad, isOpen]) => {
                document.querySelector(`#${pad}`).closest('details').open = isOpen;
            });

            return true;
        }
    }
);

document.querySelectorAll('svg [data-target]')?.forEach(anchor => {
    anchor.addEventListener('click', () => {
        const padId = anchor.getAttribute('data-target');
        const detailsEl = document.querySelector(`[id="${padId}"]`).closest('details');
        padsStateHandler[padId] = !detailsEl.open;
        detailsEl.open ? '' : anchor.blur();
    });
});

document.querySelectorAll('summary')?.forEach(summary => {
    const detailsEl = summary.closest('details');
    summary.addEventListener('click', () => {
        padsStateHandler[summary.id] = detailsEl.open;
    });
    summary.closest('details').addEventListener('toggle', () => {
        detailsEl.open ? detailsEl.scrollIntoView() : '';
        document.querySelector(`svg [data-target="${summary.id}"]`).classList.toggle('active', detailsEl.open);
    });
});

async function fetchData(route) {
    try {
      const response = await fetch(route);
      const data = await response.json();
      updatePadsValue(data);
    } catch(err) {
      alert("Please retry!");
    }
}

function updatePadsValue (data) {
    Object.keys(data.instruments).forEach(item => {
        Object.entries(data.instruments[item]).forEach(([setting, value]) => {    

            const slider = document.querySelector(`#${item}-${setting}`);
            slider && slider?.setAttribute('value', value);

            const note = document.querySelector(`#${item}-note`);
            (note && item.startsWith("note")) && note?.setAttribute('value', value);
        });
    });
};

window.addEventListener('click', (event) => {
    const element = event.target;

    if (element.closest('[id="about-modal"]') || element.closest('[data-target="about-modal"]')) {
        element.nodeName === 'BUTTON' || element.nodeName === 'DIALOG'  ?
            document.querySelector('#about-modal').toggleAttribute('open') : null;
    }
});
